import sfmUtils
import vs
import vsUtils
import sfm
import json
import os

from PySide import QtGui

# Global variables
g_OridaPath = "usermod/scripts/sfm/animset/Tools/oridafiles/"
g_OridaScriptName = "O rida"
g_OridaVersion = "1.0"
g_OridaAuthorInfo = "Created by: kjkj 2017"

def createUi():
	window = QtGui.QDialog()
	window.resize(150,150)
	window.setWindowTitle(g_OridaScriptName)

	lblHeader = QtGui.QLabel("<h2>"+g_OridaScriptName+" "+g_OridaVersion+"</h2>")
	btnLoad = QtGui.QPushButton("Load overrides")
	btnLoad.clicked.connect(lambda: onLoadClicked(window))
	btnSave = QtGui.QPushButton("Save overrides")
	btnSave.clicked.connect(lambda: onSaveClicked(window))
	btnHelp = QtGui.QPushButton("Help")
	btnHelp.clicked.connect(lambda: onHelpClicked(window))
	lblFooter = QtGui.QLabel("<i><a href='https://sfmlab.com/profile/kjkj/'>"+g_OridaAuthorInfo+"</a></i>")

	vBox = QtGui.QVBoxLayout()
	vBox.addWidget(lblHeader)
	vBox.addWidget(btnLoad)
	vBox.addWidget(btnSave)
	vBox.addWidget(btnHelp)
	vBox.addWidget(lblFooter)
    
	window.setLayout(vBox)
	window.setModal(True)
	window.exec_()

def onHelpClicked(window):
	helpWindow = QtGui.QDialog()
	helpWindow.resize(240,10)
	helpWindow.setWindowTitle("Help")

	btnOk = QtGui.QPushButton("Ok")
	btnOk.clicked.connect(lambda: helpWindow.close())

	labels = []
	labels.append(QtGui.QLabel("<h2>" + g_OridaScriptName + " " + g_OridaVersion + " help</h2>"))
	labels.append(QtGui.QLabel("The " + g_OridaScriptName + " script can be used to load and save material override configuration files for models."))
	labels.append(QtGui.QLabel("This makes it easier to re-use overrides without having to tediously re-add them in the element viewer."))

	labels.append(QtGui.QLabel("<h3>How to save overrides</h3>"))
	labels.append(QtGui.QLabel("1. Right click the animation set which has the material overrides you want to save"))
	labels.append(QtGui.QLabel("2. Select this script from the \"Rigs\" menu"))
	labels.append(QtGui.QLabel("3. Select the \"Save overrides\" option from the window"))
	labels.append(QtGui.QLabel("4. Select where to save the override configuration from the file dialog"))
	labels.append(QtGui.QLabel("<b>Note</b> All user defined attributes added to any element in the gameModel's \"materials\" array will be saved."))
	labels.append(QtGui.QLabel("The bodygroup configuration will be saved as well."))

	labels.append(QtGui.QLabel("<h3>How to load overrides</h3>"))
	labels.append(QtGui.QLabel("1. Add override materials to the animation set (Right-click -> \"Add override materials\")"))
	labels.append(QtGui.QLabel("2. Select this script from the \"Rigs\" menu"))
	labels.append(QtGui.QLabel("3. Select the \"Load overrides\" option from the window"))
	labels.append(QtGui.QLabel("4. Select a file, containing overrides for the model, from the file dialog"))
	labels.append(QtGui.QLabel("5. Profit"))

	labels.append(QtGui.QLabel("<h3>How to change default location for file dialog</h3>"))
	labels.append(QtGui.QLabel("1. Open this script in your favourite text editor (located in scripts/sfm/animset/Tools)."))
	labels.append(QtGui.QLabel("2. Near the top of the file, locate the row with the variable declaration: <i>g_OridaPath = \"usermod/scripts/sfm/animset/Tools/oridafiles/\"</i>"))
	labels.append(QtGui.QLabel("3. Replace the path inside the quotation marks with the location you prefer."))
	labels.append(QtGui.QLabel("4. Save the file. Next time you launch the script, the file dialog should point to the location you entered in the previous step."))

	vBox = QtGui.QVBoxLayout()
	for label in labels:
		vBox.addWidget(label)
	vBox.addWidget(btnOk)

	helpWindow.setLayout(vBox)
	helpWindow.setModal(True)
	helpWindow.exec_()

def onLoadClicked(window):
	animSet = sfm.GetCurrentAnimationSet()
	gameModel = animSet.gameModel
	if gameModel.HasAttribute("materials"):
		theoptions = QtGui.QFileDialog.Options(QtGui.QFileDialog.Option.DontUseNativeDialog)
		filename, _ = QtGui.QFileDialog.getOpenFileName( window, "Load overrides", g_OridaPath, "*.json", "", theoptions)
		if filename:
			with open(filename) as f:
				overrideJson = json.load(f)
				try:
					sfmUtils.AddAttributeToElement(gameModel, "body", vs.AT_INT, int(overrideJson["gameModel"]["body"]) )
				except:
					print "No bodygroup configuration found, attribute skipped"
				for oride in overrideJson["allOverrides"]:
					addOverrides(gameModel.materials, oride)
	else:
		QtGui.QMessageBox.information( window, "No override materials found", "Please add override materials first" )	
	window.close()		

def addOverrides(materials, oride):
	for element in materials:
		if str(element.name) in oride["applyTo"]:
			sfmUtils.AddAttributeToElement(element, str(oride["name"]), int(oride["type"]), str(oride["value"]) )
		elif "$everything$" in oride["applyTo"]:
			sfmUtils.AddAttributeToElement(element, str(oride["name"]), int(oride["type"]), str(oride["value"]) )

def onSaveClicked(window):
	theJson = {}
	theJson["gameModel"] = {}
	animSet = sfm.GetCurrentAnimationSet()
	gameModel = animSet.gameModel
	if gameModel.HasAttribute("materials"):
		theJson["gameModel"]["body"] = int(str(gameModel.body))
		findOverrides(gameModel.materials, theJson)
	else:
		QtGui.QMessageBox.information( None, "No override materials found", "Please add override materials first" )	
	window.close()

def findOverrides(materials, theJson):
	ignoreThese = ["name", "mtlName"]
	addedAttributes = []
	applyToMap = []
	for element in materials:
		for attr in element.iterAttrs():
			if attr.GetName() not in ignoreThese:
				attrAsJson = {}
				attrAsJson["name"] = attr.GetName()
				attrAsJson["type"] = int(attr.GetType())
				attrAsJson["value"] = str(attr)

				if attrAsJson in addedAttributes:
					applyToMap[addedAttributes.index(attrAsJson)].append(str(element.name))
				else:
					addedAttributes.append(attrAsJson)
					applyToMap.append([str(element.name)])

	i = 0
	for jsonAttr in addedAttributes:
		jsonAttr["applyTo"] = []
		for elementApply in applyToMap[i]:
			jsonAttr["applyTo"].append(elementApply)
		i += 1

	theJson["allOverrides"] = addedAttributes
	saveJson(theJson)

def saveJson(theJson):
	theoptions = QtGui.QFileDialog.Options(QtGui.QFileDialog.Option.DontUseNativeDialog)
	filename, _ = QtGui.QFileDialog.getSaveFileName( None, "Save overrides", "\\".join([g_OridaPath, "overrides.json"]), "*.json", "", theoptions)
	if filename:
		if not filename.endswith(".json"):
			filename += ".json"
		with open(filename,'w') as f:
			json.dump(theJson, f)

createUi()